unit unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ExtCtrls,
  TAGraph, TASeries, Buttons, Menus, FileUtil, ComCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Chart1: TChart;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    MCalculate: TMenuItem;
    Menu_File: TMenuItem;
    Menu_Calculate: TMenuItem;
    Menu_Grafic: TMenuItem;
    Menu_Open: TMenuItem;
    Menu_Exit: TMenuItem;
    Menu_Exp: TMenuItem;
    Menu_Curve: TMenuItem;
    OpenDialog1: TOpenDialog;
    ToolBar1: TToolBar;
    TB_Open: TToolButton;
    TB_Exit: TToolButton;
    TB_Divide_1: TToolButton;
    TB_Calculate: TToolButton;
    TB_Divide_2: TToolButton;
    TB_Graf_Exp: TToolButton;
    TB_Graf_Curve: TToolButton;
    procedure FormCreate(Sender: TObject);
    procedure Menu_ExitClick(Sender: TObject);
    procedure Menu_ExpClick(Sender: TObject);
    procedure Menu_CurveClick(Sender: TObject);
    procedure Menu_OpenClick(Sender: TObject);
    procedure MCalculateClick(Sender: TObject);

  private
    { private declarations }
  public
    { public declarations }
  end; 

procedure gauss(vector: array of real; b: array of real;
                var x: array of real; n: byte;
                var solve: byte);
// Процедура решения СЛАУ методом Гаусса
// n - размерность системы,
// solve=0, если решение единственное,
// solve=1, если система не имеет решения,
// solve=2, если система имеет бесконечное количество решений,

function fx(t: real): real;
// Функция, подбираемая методом
// наименьших квадратов

function stepen( x: real; n: byte): real;
// Функция возведения в степень
var
  Form1: TForm1; 
  n: byte;
  x1, y1: real;
  x, y, z: array of real;
  Fname: string;
  
implementation

function fx(t: real): real;
begin
  Result:= z[0] + z[1]*t + z[2]*t*t +
           z[3]*t*t*t + z[4]*sqr(sqr(t));
end;

function stepen( x: real; n: byte): real;
// процедура возведения в целую степень
var
  i: integer;
begin
  Result:= 1;
  for i:= 1 to n do
  Result:= Result*x;
end;
// Реализация метода Гаусса
procedure Gauss(vector: array of real; b: array of real;
                var x: array of real; n: byte;
                var solve: byte);
var
 a: array of array of real; { матрица коэффициентов системы,
 двумерный динамический массив}
 i, j, k, p, r: integer;
 m, s, t: real;
begin
 SetLength(a, n, n); // установка фактического размера массива

 { Преобразование одномерного массива в двумерный }
 k:=0;
 for i:=0 to n-1 do
   for j:=0 to n-1 do
   begin
     a[i,j]:= vector[k];
     k:=k+1;
   end;
 for k:=0 to n-2 do
 begin
   for i:=k+1 to n-1 do
   begin
     if (a[k,k]=0) then
     begin
       { перестановка уравнений}
       p:=k; // в алгоритме используется буква l, но она похожа на 1
             // Поэтому используем идентификатор p
       for r:=i to n-1 do
       begin
         if abs(a[r,k]) > abs(a[p,k]) then p:=r;
       end;
       if p<>k then
       begin
         for j:= k to n-1 do
         begin
           t:=a[k,j];
           a[k,j]:=a[p,j];
           a[p,j]:=t;
         end;
         t:=b[k];
         b[k]:=b[p];
         b[p]:=t;
       end;
     end; // конец блока перестановки уравнений
     m:=a[i,k]/a[k,k];
     a[i,k]:=0;
     for j:=k+1 to n-1 do
     begin
       a[i,j]:=a[i,j]-m*a[k,j];
     end;
     b[i]:= b[i]-m*b[k];
   end;
 end;
 {Проверка существования решения}
 if a[n-1,n-1] <> 0  then
 begin
   x[n-1]:=b[n-1]/a[n-1,n-1];
   for i:=n-2 downto 0 do
   begin
     s:=0;
     for j:=i+1 to n-1 do
     begin
       s:=s-a[i,j]*x[j];
     end;
     x[i]:=(b[i] + s)/a[i,i];
   end;
   solve:= 0;
 end
 else
 if b[n-1] = 0 then
 begin
   MessageDlg('Система имеет бесконечное ' +
                 'количество решений', mtInformation,[mbOK], 0);
   solve:= 2;
 end
 else
 begin
   MessageDlg('Система не имеет решений',
                 mtInformation,[mbOK], 0);
   solve:= 1;
 end;
 { освобождение памяти,
 распределенной для динамического массива }
 a:= nil;
end;

{ TForm1 }

procedure TForm1.FormCreate(Sender: TObject);
begin
  Chart1.Title.Text.Text:='Метод наименьших квадратов';
  MCalculate.Enabled:= false;
  Menu_Exp.Enabled:= false;
  Menu_Curve.Enabled:= false;
  TB_Calculate.Enabled:= false;
  TB_Graf_Exp.Enabled:= false;
  TB_Graf_Curve.Enabled:= false;
  Chart1.Visible:= false;
end;

procedure TForm1.Menu_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Menu_ExpClick(Sender: TObject);
{Процедура вывода графика экспериментальных
 данных по точкам}
var
  i: integer;
  gr1: TLineSeries;
begin
  Chart1.Visible:= true;
  gr1:= TLineSeries.Create(Chart1);
  Chart1.AddSeries(gr1);
  for i:= 0 to n - 1 do
  gr1.AddXY(x[i], y[i]);
end;

procedure TForm1.Menu_CurveClick(Sender: TObject);
{Процедура вывода совмещенных графиков
 экспериментальных данных по точкам и
 подобранной методом наименьших квадратов
 кривой, наилучшим образом приближающейся
 к экспериментальным данным}
var
  i: integer;
  gr1, gr2: TLineSeries;
begin
  Chart1.Visible:= true;
  gr1:= TLineSeries.Create(Chart1);
  gr1.ShowPoints := true; // график с точками
  gr1.ShowLines := false; // не соединять точки линиями
  Chart1.AddSeries(gr1);
  gr2:= TLineSeries.Create(Chart1);
  gr2.ShowLines := true;
  Chart1.AddSeries(gr2);
  for i:= 0 to n - 1 do
  gr1.AddXY(x[i], y[i]);
  for i:= 0 to n - 1 do
  gr2.AddXY(x[i], fx(x[i]));
end;

procedure TForm1.Menu_OpenClick(Sender: TObject);
// процедура выбора, открытия  и чтения файла данных
var
  f: TextFile;
  i: integer;
begin
 if OpenDialog1.Execute then
    Fname:= OpenDialog1.FileName
  else exit;
  Fname:= UTF8ToSys(Fname); // преобразование в системную кодировку
  AssignFile(f, Fname);
  Reset(f);
  // отключение контроля ошибок ввода/вывода
  {$I-}
  // чтение количества экспериментальных точек
  Readln(f, n);
  if IOResult <> 0 then
  begin
    ShowMessage('Ошибка при чтении из файла!');
    exit;
  end;
  // распределение памяти под массивы
  SetLength(x, n);
  SetLength(y, n);
  for i:= 0 to n - 1 do
  begin
    read(f, x[i]);
    if IOResult <> 0 then
    begin
      ShowMessage('Ошибка при чтении из файла!');
      exit;
    end;
  end;
  for i:= 0  to n - 1 do
  begin
    read(f, y[i]);
    if IOResult <> 0 then
    begin
      ShowMessage('Ошибка при чтении из файла!');
      exit;
    end;
  end;
  {$I+}
  CloseFile(f);
  MCalculate.Enabled:= true;
  TB_Calculate.Enabled:= true;
end;

procedure TForm1.MCalculateClick(Sender: TObject);
var
  i, j, k, l: integer;
  b, vector: array of real;
  s: real;
  solve: byte;
begin
  SetLength(z, 5);
  SetLength(b, 5);
  SetLength(vector, 25);
  j:= 0;
  for k:= 0 to 4 do
  for l:= 0 to 4 do
  begin
    s:= 0;
    for i:= 0 to n - 1 do
    s:= s + stepen(x[i], k+l);
    vector[j]:= s;
    j:= j+1;
  end;
  for k:= 0 to 4 do
  begin
    s:= 0;
    for i:= 0 to n - 1 do
    s:= s + y[i]*stepen(x[i], k);
    b[k]:= s;
  end;
  // решение СЛАУ
  gauss(vector, b, z, 5, solve);
  if solve = 0 then
  begin
    Menu_Exp.Enabled:= true;
    Menu_Curve.Enabled:= true;
    TB_Graf_Exp.Enabled:= true;
    TB_Graf_Curve.Enabled:= true;
  end;
end;

initialization
  {$I unit1.lrs}

end.

